#ifndef __ICountedObject__
#define __ICountedObject__

//	===========================================================================

#include "CClass.hpp"
using Exponent::Basics::CClass;

//	===========================================================================

namespace Exponent
{
	namespace Basics
	{
		/**
		 * @interface ICountedObject ICountedObject.hpp
		 * @brief Interface to a counted object
		 *
		 * @see CCountedObject
		 *
		 * @date 12/12/2005
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: ICountedObject.hpp,v 1.6 2007/02/08 21:06:44 paul Exp $
		 */
		interface ICountedObject
		{
		
//	===========================================================================
			
		public:
			
//	===========================================================================
			
			/**
			 * Construction
			 */
			ICountedObject() { }
			
			/**
			 * Destruction
			 */
			virtual ~ICountedObject() { }

//	===========================================================================

			/**
			 * Increment the reference count
			 */
			virtual void referenced() = 0;

			/**
			 * Decrement the reference count. Object is deleted if reference count is <= 0
			 */
			virtual void dereference() = 0;

			/**
			 * Get the reference count
			 * @retval long The reference count
			 */
			virtual long getReferenceCount() const = 0;

			/**
			 * Get a description of the object
			 * @param string On return is filled with the description
			 * @param size The size of the stirng
			 */
			virtual void getObjectDescription(char *string, const long size) const = 0;
		
			/**
			 * Get the class of this object
			 * @retval const CClass& The class of the object
			 */
			virtual const CClass &getObjectClass() const = 0;

//	===========================================================================
		};
	}
}

/**
 * @def EXCHANGE_COUNTED_OBJECTS(x, y)
 * Swaps two counted objects, with null pointer check and correct dereferencing of old object
 * @note DO NOT EVER CALL THIS FUNCTION IN THE FOLLOWING FASHION:\n
 * ECHANGE_COUNTED_OBJECT(m_memberVariable, SomeClassAccesor::getCountedObject(i));\n
 * remember that preprocessors will call this getCountedObject multiple times, which doesnt necessarily give the right results...
 */
#define EXCHANGE_COUNTED_OBJECTS(x, y) if ((x) != (y)) { if (x) { (x)->dereference(); } (x) = (y); if (x) { (x)->referenced(); } }

/**
 * @def FORGET_COUNTED_OBJECT(x)
 * Dereferences an object and sets it to NULL
 */
#define FORGET_COUNTED_OBJECT(x) if(x) { (x)->dereference(); } (x) = NULL;

#endif	// End of ICountedObject.hpp